import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/helper/string_format_helper.dart';
import 'package:viser_remit/core/utils/my_color.dart';
import 'package:viser_remit/core/utils/style.dart';
import 'package:viser_remit/data/controller/home/home_controller.dart';
import 'package:viser_remit/data/model/home/country_info_model.dart';
import 'package:viser_remit/view/components/snack_bar/show_custom_snackbar.dart';
import 'package:viser_remit/view/screens/bottom_nav_section/home/widget/form_section/receive_currency_field.dart';

import '../../../../../core/utils/dimensions.dart';
import '../../../../../core/utils/my_strings.dart';
import '../../../../../core/utils/util.dart';
import '../../../../components/buttons/rounded_button.dart';
import '../../../../components/text-form-field/custom_drop_down_button_with_text_field2.dart';
import 'form_section/send_currency_field.dart';

class CurrencySection extends StatefulWidget {
  const CurrencySection({super.key});

  @override
  State<CurrencySection> createState() => _CurrencySectionState();
}

class _CurrencySectionState extends State<CurrencySection> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<HomeController>(builder: (controller) {
      
      return Container(
        margin: const EdgeInsetsDirectional.only(top: 10, bottom: Dimensions.space10, start: Dimensions.space8, end: Dimensions.space8),
        width: double.infinity,
        padding: const EdgeInsets.all(14),
        decoration: BoxDecoration(
          color: Colors.white,
          boxShadow: MyUtils.getCardShadow(),
          borderRadius: const BorderRadius.all(
            Radius.circular(12),
          ),
        ),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Center(
              child: Column(
                children: [
                  Text(MyStrings.conversionRate.tr, style: semiBoldLarge),
                  const SizedBox(height: Dimensions.space8),
                  controller.selectedSendCountry.id == -1 || controller.selectedReceiveCountry.id == -1
                      ? const SizedBox()
                      : Text(
                          "${MyStrings.one.tr} ${controller.selectedSendCountry.currency ?? ''} = ${controller.selectedSendCountry.conversionRates != null &&controller.selectedSendCountry.conversionRates!.isNotEmpty  ? controller.getRateByCountryIds(
                              controller.selectedSendCountry.conversionRates,
                            ) : controller.getInitialCurrencyRate()} ${controller.selectedReceiveCountry.currency ?? ''}",
                          style: boldExtraLarge),
                  const SizedBox(height: Dimensions.space10),
                ],
              ),
            ),
            Text(MyStrings.youSend.tr, style: semiBoldDefault.copyWith(fontSize: 13, color: MyColor.body2)),
            const SizedBox(height: Dimensions.space8),
            const SendCurrencyField(),
            const SizedBox(height: Dimensions.space13),
            Text(MyStrings.recipientGets.tr, style: semiBoldDefault.copyWith(fontSize: 13, color: MyColor.body2)),
            const SizedBox(height: Dimensions.space8),
            const ReceiveCurrencyField(),
            const SizedBox(height: Dimensions.space13),
            CustomDropDownTextField2(
              fillColor: MyColor.textFieldColor,
              labelText: MyStrings.deliveryMethod.tr,
              selectedValue: controller.selectedDeliveryMethod,
              onChanged: (value) {
                controller.setSelectedDeliveryMethod(value);
              },
              items: controller.deliveryMethodList.map((CountryDeliveryMethods method) {
                return DropdownMenuItem<CountryDeliveryMethods>(
                  value: method,
                  child: Text(method.deliveryMethod?.name ?? ''.tr, style: regularDefault.copyWith(color: MyColor.body2, fontSize: 13)),
                );
              }).toList(),
            ),
            const SizedBox(height: Dimensions.space8),
            Row(
              children: [
                Text(
                  MyStrings.charge.tr,
                  style: regularDefault.copyWith(color: MyColor.primaryColor),
                ),
                const Spacer(),
                Text(
                  "+${controller.selectedDeliveryMethod.charge.toString() == 'null' && controller.isAgentSelected == false ? '0.00' : Converter.formatNumber(controller.getCharge().toString())} ${controller.selectedSendCountry.currency}",
                  style: semiBoldDefault.copyWith(color: MyColor.bodyTextColor),
                )
              ],
            ),
            const SizedBox(height: Dimensions.space8),
            Row(
              children: [
                Text(
                  MyStrings.payableAmount.tr,
                  style: regularDefault,
                ),
                const Spacer(),
                Text("${controller.countPayableAmount()} ${controller.selectedSendCountry.currency}", style: semiBoldDefault.copyWith(color: MyColor.bodyTextColor))
              ],
            ),
            const SizedBox(height: Dimensions.space12),
            RoundedButton(
                fontSize: 16,
                verticalPadding: 14,
                text: MyStrings.sendMoney.tr,
                press: () {
                  if (controller.getSendingAmountDataValidation() == '') {
                    controller.gotoNextPage();
                  } else {
                    CustomSnackBar.error(errorList: [controller.getSendingAmountDataValidation()]);
                  }
                })
          ],
        ),
      );
    });
  }
}
